#ifndef __LOCALIZER_H__
#define __LOCALIZER_H__

#include "AceParse.h"

#include "SexyAppFramework/SmartPtr.h"

#include <string>
#include <vector>

namespace Sexy
{

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
class Localizer : public AceParser
{
protected:
	struct IntInfo
	{
		std::string mName;
		std::string mStr;
		int mInt;

		IntInfo() : mInt(0) {}
		IntInfo(const std::string &theName, int theInt, const std::string &theStr) : mName(theName), mInt(theInt), mStr(theStr) {}
	};

	typedef std::vector<IntInfo> IntInfoVec;
	class StrInfo : public RefCount
	{
	protected:
		virtual ~StrInfo() { delete mIntVec; }

	public:
		StrInfo() : mIntVec(NULL) { }

		std::string mStr;
		std::string mStrName;
		IntInfoVec *mIntVec;
	};
	typedef SmartPtr<StrInfo> StrInfoPtr;


	std::vector<StrInfoPtr> mStrings;
	std::string mStrPrefix;
	void ParseString();
	void ParseDefVals();
	IntInfo* GetIntInfo(unsigned int theIntId);

public:
	Localizer();
	virtual ~Localizer();

	void Clear();

	const std::string& GetString(unsigned int theId);
	const std::string& GetStringName(unsigned int theId);
	int GetInt(unsigned int theIntId);
	int GetIntIdByStrId(unsigned int theStrId);
	int GetNumInts(unsigned int theStrId);
	const std::string& GetIntName(unsigned int theIntId);
	const std::string& GetStrParam(unsigned int theIntId);
	int GetIntByName(unsigned int theStrId, const std::string &theName, int theDef = 0);
	const std::string& GetStrParamByName(unsigned int theStrId, const std::string &theName);
	void GetStringSub(std::string &theResult, unsigned int theId, const std::string &s1, const std::string &s2 = "", const std::string &s3 = "", const std::string &s4 = "");
	static void GetStringSub(std::string &theResult, const std::string &theBaseStr, const std::string &s1, const std::string &s2 = "", const std::string &s3 = "", const std::string &s4 = "");
	static std::string StringSub(const std::string &theBaseStr, const std::string &s1, const std::string &s2 = "", const std::string &s3 = "", const std::string &s4 = "");

	virtual void DoParse();
};

}

#endif